/*:
 * @plugindesc タイトル画面のBGMの再生を遅らせるプラグイン
 * @author hisamon
 * 
 * @param Delay Time
 * @text 遅延時間（ミリ秒）
 * @desc BGMが再生されるまでの時間（ミリ秒単位）
 * @type number
 * @default 3000
 * 
 * @help
 * タイトル画面のBGMを指定した時間（ミリ秒）遅らせて再生します。
 */

(function() {
    var parameters = PluginManager.parameters('CustomTitleBGM');
    var delayTime = Number(parameters['Delay Time'] || 3000); // デフォルトは3秒遅延

    Scene_Title.prototype.start = function() {
        Scene_Base.prototype.start.call(this);
        SceneManager.clearStack();
        if (this._fadeSprite) {
            this._fadeSprite.fadeOut(this.fadeSpeed());
        }
        this.playTitleMusicWithDelay();
        this.startFadeIn(this.fadeSpeed(), false);
    };

    Scene_Title.prototype.playTitleMusicWithDelay = function() {
        AudioManager.stopAll();
        setTimeout(function() {
            if (!$dataSystem.titleBgm.name) return;
            AudioManager.playBgm($dataSystem.titleBgm);
        }, delayTime);
    };
})();